﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Drawing;
using System.Data;
using System.Linq;
using System.Text;
using System.Windows.Forms;
using Winfoot_7_SDK;
using WinfootDefaultSystemPlugin.Controls.Strategy;

namespace WinfootDefaultSystemPlugin.Controls
{
    public partial class NoThumbnailCache : UserControl,ICorrespondenceOS,IControl
    {
        private NoThumbnailCacheController noThumbnailCacheController;

        public NoThumbnailCache()
        {
            InitializeComponent();
           CorrespondenceOSList = new List<OS>
                                       {
                                           OS.WindowsXP,
                                           OS.WindoesXP_SP1,
                                           OS.WindowsXP_SP2,
                                           OS.WindowsXP_SP3,                                             
#if DEBUG
                                           OS.WindowsVista,
                                           OS.WindowsVista_SP1,
                                           OS.WindowsVista_SP2,
                                           OS.WindowsSeven
#endif
                                       };
        }

        private void groupBox1_MouseClick(object sender, MouseEventArgs e)
        {
            if (e.Button == MouseButtons.Right)
            {
                UserHelp userHelp = new UserHelp(new Uri(@"http://www.google.co.jp/"));
                userHelp.Show();
            }
        }

        public void SetNoThumbnailCacheState(bool b)
        {
            checkBox1.Checked = b;
        }


        public int GetNoThumbnailCacheState()
        {
            if (checkBox1.Checked)
            {
                return 1;
            }
            return 0;
        }

        #region IControl メンバ

        public void Apply()
        {
            noThumbnailCacheController.Write();
        }

        public List<WFRegistry> BackUp()
        {
            return noThumbnailCacheController.BackUp();
        }

        #endregion

        #region ICorrespondenceOS メンバ

        public List<OS> CorrespondenceOSList { get; set; }

        #endregion

        private void NoThumbnailCache_Load(object sender, EventArgs e)
        {
            WFUtillity wfUtillity = new WFUtillity();
            noThumbnailCacheController = new NoThumbnailCacheController(this,
                                                                        (INoThumbnailCacheStrategy)
                                                                        wfUtillity.
                                                                            GetCorrespondenceInstance
                                                                            (new List<ICorrespondenceOS>
                                                                                 {
                                                                                     new NoThumbnailCacheDefaultStrategy()
                                                                                 }));
            noThumbnailCacheController.Read();
        }
    }
}
